local assets =
{
	Asset("ANIM", "anim/ghost.zip"),
	Asset("ANIM", "anim/ghost_wendy_build.zip"),
	Asset("SOUND", "sound/ghost.fsb"),
}

local prefabs = 
{
}




local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()

    MakeGhostPhysics(inst, 0.01, .001)
    
    	inst:AddTag("playerfriends")

    
    inst:AddTag("noauradamage")
    inst:AddTag("notraptrigger")

    inst:AddComponent("locomotor") -- locomotor must be constructed before the stategraph
    inst.components.locomotor.walkspeed = TUNING.ABIGAIL_SPEED
    inst.components.locomotor.runspeed = TUNING.ABIGAIL_SPEED
    
    inst:SetStateGraph("SGcam")

    inst:AddComponent("playercontroller_camera")
	inst.persists=false

    inst:AddComponent("inspectable")
    
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(9000)

    
	------------------    
    
 ---   inst.SoundEmitter:PlaySound("dontstarve/ghost/ghost_girl_howl_LP", "howl")
    
    
    return inst
end

return Prefab( "common/monsters/camera_prefab", fn, assets, prefabs ) 
